/** 2. Base となる Canvas要素を取得する */
const canvas = document.getElementById("canvas");

// 3. Canvas要素のサイズを設定する。
canvas.setAttribute("width", "200");
canvas.setAttribute("height", "200");
  /**
   * 4. Canvas要素からコンテキストを取得する。
   * => キャンバスへの描画は、コンテキスト（CanvasRenderingContext2Dインスタンス）経由でおこないます。
   * => 今回は、2D(2次元)コンテキストを使用します。
   * */
  const context = canvas.getContext("2d");

  /**
   * 6-1. コンテキストを使用して、目的物を描画する。
   *  => 画像を Canvasに合成する
   * NOTE: drawImage(image, dx, dy, dWidth, dHeight)
   * => Canvas 2D API の CanvasRenderingContext2D.drawImage() メソッドは、
   * キャンバスに画像を描画するいくつかの方法を提供します。
   * => 今回は、x, y 座標ともに原点から、Startして、幅・高さを Canvasと同じサイズにしています。
   * => つまり、Canvasに、ピッタリ収まるサイズで、描かれる。
   */

  /**
   * 5. コンテキスト内の設定をする
   * => 描く図形の塗りつぶしの Color(透明な赤色)を Setする
   */
  context.fillStyle = "rgba(255, 0, 0, 0.5)";

  context.fillRect(75, 50, 50, 50);